/**
 * Weather
 *
 * Screen Routines
 */

#include <msx.h>
#include <eos.h>
#include <smartkeys.h>
#include <conio.h>
#include <sys/ioctl.h>
#include "screen.h"

const unsigned char spritedata[]=
  {
   // Sunny
   0x04,0x44,0x20,0x07,0x0F,0x1F,0x1F,0x1F,0xDF,0x1F,0x1F,0x0F,0x07,0x20,0x44,0x04,0x20,0x22,0x04,0xE0,0xF0,0xF8,0xF8,0xF8,0xFB,0xF8,0xF8,0xF0,0xE0,0x04,0x22,0x20,
   
   // Half Sunny
   0x04,0x44,0x20,0x07,0x0F,0x9F,0x5F,0x1F,0x1F,0x1F,0x1F,0x0F,0x07,0x00,0x00,0x00,0x20,0x22,0x04,0xE0,0xF1,0xFA,0xF8,0xF8,0xF8,0xF8,0xF8,0xF0,0xE0,0x00,0x00,0x00,

   // Cloud 1
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x6F,0xFF,0xFF,0xFF,0x7F,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xCC,0xFE,0xFF,0xFF,0xFF,0xFE,0xF8,0xF0,

   // Cloud 2
   0x00,0x00,0x00,0x03,0x07,0x6F,0xFF,0xFF,0xFF,0x7F,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xCC,0xFE,0xFF,0xFF,0xFF,0xFE,0xF8,0xF0,0x00,0x00,0x00,0x00,

   // Cloud 3
   0x00,0x00,0x03,0x07,0x6F,0xFF,0xFF,0xFF,0x7F,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xCC,0xFE,0xFF,0xFF,0xFF,0xFE,0xF8,0xF0,0x00,0x00,0x00,0x00,0x00,

   // Cloud 4
   0x03,0x07,0x6F,0xFF,0xFF,0xFF,0x7F,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xCC,0xFE,0xFF,0xFF,0xFF,0xFE,0xF8,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

   // Mist 1
   0x05,0x00,0x20,0x00,0x40,0x00,0x80,0x00,0x20,0x00,0x40,0x00,0x10,0x00,0x0B,0x00,0xB4,0x00,0x08,0x00,0x02,0x00,0x01,0x00,0x02,0x00,0x01,0x00,0x02,0x00,0x68,0x00,

   // Mist 2
   0x00,0x00,0x0D,0x00,0x1B,0x00,0x37,0x00,0x2F,0x00,0x1B,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0xD8,0x00,0xEC,0x00,0xD8,0x00,0xEC,0x00,0xD0,0x00,0x00,0x00,

   // Moon
   0x00,0x00,0x0D,0x00,0x1B,0x00,0x37,0x00,0x2F,0x00,0x1B,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0xD8,0x00,0xEC,0x00,0xD8,0x00,0xEC,0x00,0xD0,0x00,0x00,0x00,

   // Cloud 5
   0x03,0x07,0x6F,0xFF,0xFF,0xFF,0x7F,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xCC,0xFE,0xFF,0xFF,0xFF,0xFE,0xF8,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

   // Cloud 6
   0x03,0x07,0x6F,0xFF,0xFF,0xFF,0x7F,0x1F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xCC,0xFE,0xFF,0xFF,0xFF,0xFE,0xF8,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

   // Lightning 1
   0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x06,0x0F,0x00,0x00,0x01,0x07,0x03,0x02,0x00,0x00,0x00,0x00,0x00,0xC0,0x80,0x00,0x00,0xF0,0x60,0xC0,0x80,0xC0,0x80,0x00,

   // Lightning 2
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x07,0x00,0x00,0x00,0x03,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x60,0xC0,0x80,0x00,0xF8,0x30,0x60,0xC0,0xE0,0xC0,0x00,

   // Rain 1
   0x00,0x00,0x00,0x00,0x08,0x0A,0x02,0x10,0x14,0x05,0x21,0x28,0x0A,0x42,0x50,0x14,0x00,0x00,0x00,0x00,0x00,0x04,0x84,0xA0,0x2A,0x0A,0x40,0x54,0x14,0x80,0xA8,0x20,

   // Rain 2
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x21,0x28,0x0A,0x42,0x50,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x41,0x55,0x14,0x80,0xAA,0x22,

   // Snow 1
   0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x0A,0x04,0x20,0x51,0x20,0x00,0x44,0xE0,0x40,0x00,0x00,0x00,0x80,0x00,0x20,0x50,0x22,0x05,0x92,0x40,0x90,0x00,0x4A,0xE0,0x44,

   // Snow 2
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x24,0x80,0x15,0x4A,0xA4,0x49,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x02,0x00,0x84,0x01,0x12,0x45,0xA2,0x48,

   // Lightning 3
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x03,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x60,0xC0,0x80,0xFC,0x18,0x30,0x60,0xF0,0xE0,0x80,   
  };

const unsigned char udgs[]=
  {
   // Digits 0-9 as 16x16 chars
   0x03,0x0F,0x0C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x0C,0x0F,0x03,0xC0,0xF0,0x30,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x30,0xF0,0xC0,
   0x01,0x03,0x07,0x07,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x07,0x07,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xE0,0xE0,
   0x03,0x0F,0x0C,0x18,0x18,0x00,0x00,0x00,0x01,0x03,0x07,0x0E,0x1C,0x18,0x1F,0x1F,0xC0,0xF0,0x30,0x18,0x18,0x38,0x70,0xE0,0xC0,0x80,0x00,0x00,0x00,0x00,0xF8,0xF8,
   0x03,0x0F,0x0C,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x0C,0x0F,0x03,0xC0,0xF0,0x30,0x18,0x18,0x18,0x30,0xE0,0xE0,0x30,0x18,0x18,0x18,0x30,0xF0,0xC0,
   0x01,0x01,0x03,0x03,0x06,0x06,0x0C,0x0C,0x18,0x18,0x3F,0x3F,0x00,0x00,0x00,0x00,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xF0,0xF0,0xC0,0xC0,0xC0,0xC0,
   0x1F,0x1F,0x18,0x18,0x18,0x18,0x1B,0x1F,0x1C,0x00,0x00,0x18,0x18,0x0C,0x0F,0x03,0xF8,0xF8,0x00,0x00,0x00,0x00,0xC0,0xF0,0x30,0x18,0x18,0x18,0x18,0x30,0xF0,0xC0,
   0x03,0x0F,0x0C,0x18,0x18,0x18,0x1B,0x1F,0x1C,0x18,0x18,0x18,0x18,0x0C,0x0F,0x03,0xC0,0xF0,0x30,0x18,0x18,0x00,0xC0,0xF0,0x30,0x18,0x18,0x18,0x18,0x30,0xF0,0xC0,
   0x0F,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x03,0x03,0x03,0xF8,0xF8,0x30,0x30,0x60,0x60,0x60,0xC0,0xC0,0xC0,0x80,0x80,0x80,0x00,0x00,0x00,
   0x03,0x0F,0x0C,0x18,0x18,0x18,0x0C,0x07,0x07,0x0C,0x18,0x18,0x18,0x0C,0x0F,0x03,0xC0,0xF0,0x30,0x18,0x18,0x18,0x30,0xE0,0xE0,0x30,0x18,0x18,0x18,0x30,0xF0,0xC0,
   0x03,0x0F,0x0C,0x18,0x18,0x18,0x18,0x1C,0x0F,0x03,0x00,0x18,0x18,0x0C,0x0F,0x03,0xC0,0xF0,0x30,0x18,0x18,0x18,0x18,0x38,0xF8,0xD8,0x18,0x18,0x18,0x30,0xF0,0xC0,

   // Degree symbol
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x3C,0x66,0x66,0x3C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

   // Negative symbol
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,

   // . symbol
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,

   // FARENHEIT
   0x1F,0x1F,0x18,0x18,0x18,0x18,0x18,0x1F,0x1F,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0xF8,0xF8,0x00,0x00,0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

   // CELSIUS
   0x03,0x0F,0x0C,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x0C,0x0F,0x03,0xC0,0xF0,0x30,0x18,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30,0xF0,0xC0,
  };

void screen_bigprint_offsets(char *c, unsigned char *c0, unsigned char *c1, unsigned char *c2, unsigned char *c3)
{
  // 0 2 1 3
  unsigned char o=0x80; // Initial char offset
  char t = *c;
  
  switch(t)
    {
    case '*':
      o+=0x28;
      break;
    case '-':
      o+=0x2C;
      break;
    case '.':
      o+=0x30;
      break;
    case 'F':
      o+=0x34;
      break;
    case 'C':
      o+=0x38;
      break;
    default:
      t -= 0x30;
      t *= 4;
      t += 0x80;
      o=t;
      break;
    }

  *c0=o;
  *c1=o+2;
  *c2=o+1;
  *c3=o+3;
}

void screen_bigprint(unsigned char x,unsigned char y,char *c)
{
  x <<= 2;
  y <<= 2;

  while (*c != 0x00)
    {
      unsigned char c0,c1,c2,c3;
      
      screen_bigprint_offsets(c,&c0,&c1,&c2,&c3);
      if ((*c == '.') || (*c == '*'))
	{
	  gotoxy(x,y  ); cprintf("%c",c1);
	  gotoxy(x,y+1); cprintf("%c",c3);
	  x += 1;	  
	}
      else
	{
	  gotoxy(x,y  ); cprintf("%c%c",c0,c1);
	  gotoxy(x,y+1); cprintf("%c%c",c2,c3);
	  x += 2;
	}
      c++;
    }
}

void screen_test(void)
{
  void *param = &udgs;

  console_ioctl(IOCTL_GENCON_SET_UDGS,&param);
  smartkeys_set_mode();
  smartkeys_display(NULL,NULL,"LOCATION","  SHOW\nFORECAST","  SHOW\n CELSIUS"," REFRESH");
  smartkeys_status("\n  TEST SCREEN");

  eos_write_vdp_register(1,0xE3);
  msx_vwrite(spritedata,0x3800,sizeof(spritedata));

  // Date
  gotoxy(8,0); cprintf("27 Oct 2022, Sun");  
  
  // Sun with clouds
  msx_vpoke(0x1b00,0x20);
  msx_vpoke(0x1b01,0x08);
  msx_vpoke(0x1b02,0x04);
  msx_vpoke(0x1b03,0x0F);
  
  msx_vpoke(0x1b04,0x20);
  msx_vpoke(0x1b05,0x08);
  msx_vpoke(0x1b06,0x00);
  msx_vpoke(0x1b07,0x0A);

  // 64.7*F
  screen_bigprint(2,1,"64.7*F");

  // 30.84 HG
  gotoxy(23,4); cprintf("30.84\"Hg");

  // Sun /w clouds
  gotoxy(7,7); cprintf("Sunny with clouds");

  // Dallas, US
  gotoxy(12,9); cprintf("Dallas, US");

  smartkeys_puts(0,96,"WIND: 10.36 MPH N\nFEELS LIKE: 28.47 deg F\n\nDEW POINT: 24.42 deg F\nVISIBILITY: 10km\n\nTIME ZONE: GMT-6");
  smartkeys_puts(160,96,"SUNRISE: 07:01am\nSUNSET: 06:22pm\n\nHUMIDITY: 60%\nCLOUDS: 100%\n\nTIME: 2:15pm");
  
}
